cc  FORTRAN code: Example 11.6 (Test statistic C_{T,p}(d,m), 
cc                              second column of Table 11.2)
cc  Coded by: Ruey S. Tsay
cc  File: mtarid.for
cc
cc  This program is intended for nonlinear time series analysis.
cc
cc  Created on May 15, 1997 to analyze multivariate TAR models. 
cc
cc  The program uses "regressions" to identify the threshold lag.
cc  That is, the program is used to specify the threshold lag: d
cc
cc  The program allows for specification of data span (nst, nend).
cc
cc  INPUT:
cc  nob  nvar  ny  nx  thrloc  rm(m)  start-perc
cc  66    2     2   0    2      0       25
cc  data_file name: tt.dat
cc  input dat span ? (1 = yes): 0
cc  loc_y: 1 2
cc  AR-order:  4
cc  wish to give thr-lages? (1 yes): 0
cc  wish to standardize the residuals (1 = yes): 1
cc
cc  OUTPUT:
cc  The-lag  Tst-statistics   Degrees of freedom of delay  d
cc -------  --------------   ------------------
cc     1          21.587         18   =   9   *   2
cc     2          13.758         18       9       2
cc     3          34.222         18       9       2
cc     4          23.655         18       9       2
cc     5          19.315         18       9       2
cc     6          14.554         18       9       2
cc     7          15.038         18       9       2
cc     8          10.273         18       9       2
cc     9          14.520         18       9       2
cc    10          12.181         18       9       2
cc
cc Critical chi^2 value at df=18 and 5% = 27.5871
cccccccccccccc Current setting
c    max-variables = 5
cc   max-ar-p      = 50
cc   max-#-thr-lag = 15
cc   max-obs       = 10000
cc
cc rm(m) is a switch for testing stage, not for the regular estimation!!!
c
       parameter(maxn=10000,md=50,mk=5)
       real*8 xpx(md,md),xpy(md,mk),xpxinv(md,md) 
       real*8 phi(md,mk),y(maxn,mk),dat(maxn,6), gain(md)
       real*8 resi(maxn,mk), thr(maxn), fra, tem, rss(mk)
       real*8 x(maxn,md), pre, presi(maxn,mk) 
       real*8 wk1(md), wk2(md,md), z(maxn), z1(maxn), tem1
c
       integer ixt(maxn),nob, p, ip, lagth,thrlag(15)
       integer locy(mk), locthr, nx, locx(mk), nvar, i, j, maxth
       integer istd, iorx(5), ist, ia, ii, jj, jst, it
       integer nthres, jend, nst, nend, ny, jrm, perc
       integer ixlag(10,5)
c
       character nfile*30
c
       iout = 23
c
c---------- nob = # of observations; p = ar-order
c
       write(6,1)
    1  format(1x,'Nob, nvar, ny, nx, thrloc, rm(m), start-p:): ',$)
       read(5,*) nob, nvar, ny, nx, locthr, jrm, perc
       if(nob .le. 0)stop
       if(nob .gt. maxn)nob = maxn
       if(nvar .le. 0)nvar = 1
       if(nvax .gt. 6)then
        print*,'too many variables! (the maximum is 6)'
        stop
       endif
       if(ny.lt.1)ny = 1
       if((nx+ny).gt.mk)then
        print*,'too many dependent and independent variables'
        stop
       endif
c
       write(6,2)
    2  format(1x,'Data_file Name: ',$)
       read(5,3)nfile
    3  format(a30)
       open(unit=21,file=nfile,status='old')
       do 4 i = 1, nob
 4        read(21,*)(dat(i,j),j=1,nvar)
       close(21)
c
      write(6,105)
 105  format(1x,'input data span? (1=yes): ',$)
      read(5,*) ii
      if(ii .eq. 1)then
        write(6,106)
        read(5,*) nst, nend
        if(nend.gt.nob) nend = nob
        if(nst.lt.1)nst = 1
        nob = nend - nst + 1
c--------------- if nst = 1, there is no need to change the data.
        if(nst.eq.1)go to 415
        do 410 it=1, nob
         do 408 i = 1, nvar
 408        dat(it,i) = dat(it+nst-1,i)
 410        continue
      endif
 106   format(1x,'data span (nst, nend): ',$)
 415   continue
c
       write(6,5)
 5     format(1x,'loc_y: ',$)
       read(5,*) (locy(i),i=1,ny) 
       if(nx.gt.0)then
        write(6,7)
        read(5,*)(locx(i),i=1,nx)
       endif
 7      format(1x,'loc_x: ',$)
       write(6,8)
 8     format(1x,'AR order: ',$)
       read(5,*) p
       if(nx.gt.0)then
        write(6,9)
        read(5,*)(iorx(i),i=1,nx)
        do 44 i=1, nx
          do 42 j=1, iorx(i)
 42          ixlag(j,i) = j
 44          continue
        write(6,54)
        read(5,*) j
        if(j.eq.1)then
        do 53 i=1, nx
         write(6,56) i
         read(5,*)(ixlag(it,i),it=1,iorx(i))
 53      continue
        do 52 i=1, nx
         do 51 it=1, iorx(i)
          if(ixlag(it,i).lt.0)then
           print*,'negative lag is not allowed'
           stop
          endif
 51       continue
 52      continue
        endif
       endif
 9      format(1x,'orders of the x-variables: ',$)
 54     format(1x,'input detailed lags for exog. vars? (1=yes): ',$)
 56     format(1x,'lags for the',i3,'-th exog. var(L to H): ',$)
c      
c
c----------------------- # of possible threshold-lags, i.e. d.
       write(6,11)
   11  format(1x,'# of thr-lags: ',$)
       read(5,*)maxth
       if(maxth .gt. 15)maxth=15
       write(6,12)
   12   format(1x,'Wish to give the thr-lags? (1=yes): ',$)
       read(5,*)iyes
   13   format(1x,'Input',i3,' thr-lags: ',$)
       if(iyes .eq. 1)then
        write(6,13) maxth
        read(5,*)(thrlag(i),i=1,maxth)
       else
        do i = 1, maxth
         thrlag(i) = i
        enddo
       endif
c
c------------------------- Switch for controlling type of residuals to
c                          be used in doing the F-stat.
       write(6,15)
   15  format(1x,'Wish to standardize the residuals? (1=yes): ',$)
       read(5,*)istd
c
      iend = perc
c
      ist = p
      if(nx.gt.0)then
       do 17 i=1, nx
 17       if(ist.lt.ixlag(iorx(i),i))ist=ixlag(iorx(i),i)
      endif
c
c------- including a constant term (ip = dimension of x-matrix)
       ip = 1+p*ny
       if(nx.gt.0)then
        do 18 i=1, nx
 18        ip = ip + iorx(i)
       endif
       if(ip.gt.md)then
        print*,'dimension exceeds specification'
        stop
       endif
c
cc       print*,'iend, ist, ip, locthr: ', iend, ist, ip, locthr
c
       do 20 i = 1, nob
 20       thr(i) = dat(i,locthr)
c
       write(iout,103)
  103  format(1x,'The-lag  Tst-statistics   Degrees of freedom')
  104  format(1x,'-------  --------------   ------------------')
       write(iout,104)
c
       do 3000  ia = 1, maxth
c
       lagth = thrlag(ia)
c----------------- jst: the first available y(.) for regression.
       jst = max0(ist, lagth)+1
c-------- Figure out the values of the threshold variable in the regression
c         so that they can be sorted.
c
        do 21 i = jst, nob
         ii = i - jst + 1
         ixt(ii) = i 
         z(ii) = thr(i-lagth)
 21      continue
       nthres =nob-jst+1
c------ sorting the values of threshold var; y(.) is an working area.
       call sort(nthres,z,ixt,z1)
c
c---- setup the regression format based on the order of threshold variable.
c    (i.e., in the arranged autoregressive format.) 
c (This program uses lots of space here. This is for simplicity.)
c
       do 80 it=jst, nob
        iy = ixt(it-jst+1) 
        do 28 i=1, ny
         y(it,i) = dat(iy,locy(i))
 28      continue
        idx = 1
        x(it,1) = 1.0d0
        if(p.gt.0)then
         do 30 j=1, ny
          do 29 i=1, p 
            idx=idx+1
 29         x(it,idx) = dat(iy-i,locy(j))
 30       continue
        endif
c
        if(nx.gt.0)then
         do 60 i=1, nx
          if(iorx(i).gt.0)then
           do 40 j=1, iorx(i)
            idx=idx+1
 40           x(it,idx) = dat(iy-ixlag(j,i),locx(i))
          endif
 60       continue
        endif
 80     continue
c
       if(ip.ne.idx)then
        print*,'dimension error'
        stop
       endif
ccc        print*, 'idx, ia: ', idx, ia
c
c--------- Start the recursion with iend observations
c
       jend = jst+iend-1
c
c--------- xpx matrix and xpy-matrix
c
       do 90 ii=1, idx
        do 85 jj=1, ii
         tem = 0.0d0
         do 82 it=jst, jend
 82         tem=tem+x(it,ii)*x(it,jj)
           xpx(jj,ii) = tem
 85        xpx(ii,jj) = tem
 90       continue
c
      do 97 jj=1, ny
       do 95 ii=1, idx
        tem = 0.0d0
        do 93 it=jst, jend 
 93       tem=tem+x(it,ii)*y(it,jj)
 95       xpy(ii,jj) = tem
 97       continue
c
      call mtinv(xpx,xpxinv,md,idx)
c
c---- initial LSE
c
      do 107 i=1, ny 
       do 100 ii=1, idx
        tem = 0.0d0
        do 98 jj=1, idx
 98        tem=tem+xpxinv(ii,jj)*xpy(jj,i)
 100      phi(ii,i)=tem
 107   continue
c----------residuals
      do 130 i=1, ny 
       rss(i) = 0.0d0
       do 120 it=jst, jend
        tem = 0.0d0
        do 110 ii=1, idx
 110      tem = tem + phi(ii,i)*x(it,ii)
       resi(it,i) = y(it,i)-tem
       rss(i) = rss(i) + resi(it,i)*resi(it,i)
 120   continue
 130   continue
c
c------ recursive L.S.
c
       if((nob-jend).lt.(ist+maxth))then
        print*,'insufficient # obs in recursive regression'
        stop
       endif
c
       do 300 it = jend+1, nob
c
c---- compute the variance of predictive residuals
c
c----------------- 1 + x(t)*xpxinv(.,.)*x(t)' = pre (defined as)
        do 140 i = 1, idx
         tem = 0.0d0
          do 125 j = 1, idx
           tem = tem + xpxinv(i,j)*x(it,j)
 125       continue
         wk1(i) = tem
 140     continue
c
        pre = 1.0d0
        do 150 i = 1, idx
         pre = pre + x(it,i)*wk1(i)
 150     continue
c---------- gain
        do 160 i=1, idx
         gain(i) = wk1(i) / pre
 160     continue
c-------- predicted residual
        do 175 ii=1, ny 
         tem = 0.0d0
         do 170 i = 1, idx
          tem = tem + x(it,i)*phi(i,ii)
 170     continue
         presi(it,ii) = y(it,ii) - tem
 175    continue
c------- update the coefficients
        do 185 ii=1, ny
         do 180 i = 1, idx
          phi(i,ii) = phi(i,ii) + gain(i)*presi(it,ii)
 180     continue
 185    continue
c------ standardize the residuals (without the estimate of sigma-square)
        if(istd .eq. 1)then
         tem = dsqrt(pre)
         do 195 ii=1, ny 
          presi(it,ii) = presi(it,ii) / tem
 195      continue
        endif
c-------- update the inverse matrix
        do 200 ii = 1, idx
         do 190 jj = 1, idx
          xpxinv(ii,jj) = xpxinv(ii,jj) - wk1(ii)*wk1(jj)/pre
 190      continue
 200      continue
c--------- compute the LS residual (This part is not needed.)
cc        do 215 jj=1, ny
cc         tem = 0.0d0
cc         do 210 ii=1, idx
cc 210        tem=tem + phi(ii,jj)*x(it,ii)
cc         resi(it,jj) = y(it,jj) - tem
cc         rss(jj) = rss(jj) + resi(it,jj)*resi(it,jj)
 215     continue
c
c------- complete the recursion and repeat the loop.
 300    continue
c
c        print*,'final estimates: '
cc          do jj=1, idx
cc          write(6,301)(phi(jj,ii),ii=1,ny)
cc          enddo
 301    format(1x,7f9.5)
c
c---------- Test for threshold models
c  That is, regression predictive residuals on the regressors
c
       do 320 ii=1, idx
c----------------------------- xpxinv-matrix 
        do 310 jj=1, ii
         tem = 0.0d0
         do 305 it=jend+1, nob
 305        tem=tem+x(it,ii)*x(it,jj)
        xpx(ii,jj) = tem
 310    xpx(jj,ii) = tem
cc------------- xpy-matrix
       do 318 j=1, ny
        tem = 0.0d0
        do 313 it=jend+1, nob
 313       tem=tem+x(it,ii)*presi(it,j)
 318      xpy(ii,j) = tem
c
 320    continue
       call mtinv(xpx,xpxinv,md,idx)
c----------- LSE
       do 342 i=1, ny
        do 340 ii=1, idx
         tem = 0.0d0
         do 330 jj=1, idx
 330       tem=tem + xpxinv(ii,jj)*xpy(jj,i)
 340       phi(ii,i) = tem
 342     continue
c
c------------- residuals
       do 355 i=1, ny 
        do 350 it=jend+1, nob
         tem = 0.0d0
         do 345 ii=1, idx
 345       tem=tem+phi(ii,i)*x(it,ii)
         resi(it,i) = presi(it,i) - tem
 350     continue
 355    continue
c
      if(jrm.eq.1)then 
c----------- Compute (and remove) sample means
      do 358 i = 1, ny
       tem = 0.0d0
       do 356 it=jend+1, nob
 356      tem = tem + presi(it,i)
       tem = tem/dfloat(nob-jend)
       do 357 it=jend+1, nob
 357      presi(it,i) = presi(it,i) - tem
 358      continue
      endif
c
c-------------- SST and SSR
        do 380 i=1, ny
         do 375 j=1, i
          tem = 0.0d0
          tem1 = 0.0d0
          do 360 it=jend+1, nob
           tem = tem + presi(it,i)*presi(it,j)
 360       tem1= tem1 + resi(it,i)*resi(it,j)
cc         xpx(i,j) = tem/dfloat(nob-jend)
         xpx(i,j) = tem
         xpx(j,i) = xpx(i,j)
cc         xpxinv(i,j) = tem1/dfloat(nob-jend)
         xpxinv(i,j) = tem1
         xpxinv(j,i) = xpxinv(i,j)
 375     continue
 380    continue
c
c--------------- construct the test statistic
       call detmtx(xpx,wk2,md,ny,fra)
       call detmtx(xpxinv,wk2,md,ny,tem)
c
cc       jj = max0(ist,lagth)
cc       ii = nob-jend-jj
       ii = nob - jend
c----------------- it denotes the number of regressors.
       it = p*ny+1
       if(jrm.eq.1)it = it-1
       if(nx.gt.0)then 
        do 402 i=1, nx
 402       it = it + iorx(i)
       endif
c--------- See page 309 of Johnson and Wichern for the modification.
       if(jrm.eq.1)then 
c        tem1 = dfloat(ii-it-1)-0.5d0*dfloat(ny-it+1)
        tem1 = dfloat(ii-it-1)
       else
c        tem1 = dfloat(ii-it)-0.5d0*dfloat(ny-it)
        tem1 = dfloat(ii-it)
       endif
       fra = tem1*(dlog(fra)-dlog(tem))
c
       jj = idx*ny
       if(jrm.eq.1)jj = jj-ny
       print*,lagth, fra, jj
       write(iout,101) lagth, fra, jj
c--------------- return for another threshold lag.
 3000  continue
c
  101  format(1x,i5,2x,f14.3,3x,i8)
       print*,'Output file: fort.23'
c
       stop
       end
ccccccccccccccccccccccccccccccccccccccccccccccccccc
       subroutine sort(n,y,ixt,x)
c
       real*8 x(*),y(*),temp
       integer ixt(3000),n,m
c
       m = n
       if(m .le. 1)return
c
       do j = 1, m
        x(j) = y(j)
       end do
c
   80  m = m - 1
       if(m .eq. 0)go to 90
c
       i = 0
   70  i = i + 1
       if(i .gt. m)go to 80
       if(x(i) .lt. x(i+1))go to 70
c-------------------- exchange x(i) and x(i+1)
       temp = x(i)
       x(i) = x(i+1)
       x(i+1) = temp
c----------------------- exchange ixt(i) and ixt(i+1)
       item = ixt(i)
       ixt(i) = ixt(i+1)
       ixt(i+1) = item
       go to 70
c
   90  return
       end
ccccccccccccccccccccccccccccccccccccccccccc
      subroutine mtinv(a, da, kcomp,idim)
c**** 
      integer i,j,kcomp,idim,ii
      real*8 a(kcomp,kcomp), da(kcomp,kcomp)
      real*8 dpivot, pivot, deta, t

      deta = 1.0d0
c**** 
      if (idim .eq. 1) goto 600
      do 100 i = 1, idim
      do 100 j = 1, idim
  100 da(i,j) = a(i,j)
  120 do 500 i = 1, idim
      pivot = da(i,i)
c**** 
c**** DIVIDE PIVOT ROW BY PIVOT ELEMENT.
c**** 
      deta = deta * pivot
      da(i,i) = 1.0d0
      dpivot = pivot + 1.0d-25
      dpivot = da(i,i) / dpivot
      pivot = dpivot
      do 200 j = 1, idim
c**** 
c**** REDUCE NON-PIVOT ROWS
c****
  200 da(i,j) = da(i,j) * pivot
  210 do 500 ii = 1, idim
      if (ii .eq. i) goto 500
      t = da(ii,i)
      da(ii,i) = 0.0d0
      do 300 j = 1, idim
c****
  300 da(ii,j) = da(ii,j) - (da(i,j) * t)
  500 continue
      return 
  600 da(1,1) = deta / a(1,1)
      return 
      end
c****
c**** END OF 'MTINV'
c**** 
c*****************************************
       subroutine detmtx(a,wk,mx,k,det)
c
c---- This program computes the determinant of a covariance matrix.
c     It assumes that the variance of each variable is not close to zero.
c     The program transforms the mtx into an upper triangular one.
c
       real*8 a(mx,mx), det, tem, wk(mx,mx), crit
       integer mx, k, i, j, km1
c--------- wk(.,.) is a working area.
c
       if(k.eq.1)then
        det = a(1,1)
        return
       endif
c
       km1 = k-1
       crit = 1.0d-15
c
       do 10 i=1, k
        do 10 j=1, k
 10        wk(i,j) = a(i,j)
c
       do 50 i=1, km1
        if(dabs(a(i,i)).le.crit)then 
         det = 0.0d0
         return
        endif
        tem = wk(i+1,i)/a(i,i)
        do 40 j=i+1, k
 40       wk(i+1,j) = wk(i+1,j)-wk(i,j)*tem
 50      continue
c
       det = 1.0d0
       do 60 i=1, k
 60       det = det*wk(i,i)
c
cc       print*,'det = ', det
c
       return
       end
c


